// DEFINITIONS ////////////////////////////////////////////////
const float PI = 3.14159265358979323846;

struct DensityProfileLayer 
{
	float 	_width;
	float 	_exp_term;
	float 	_exp_scale;
	float 	_linear_term;
	float 	_constant_term;
};

struct DensityProfile 
{
	DensityProfileLayer _layers[2];
};

struct AtmosphereParameters {
 
	vec3 			_solar_irradiance;
	float 			_sun_angular_radius;
	float 			_bottom_radius;
	float 			_top_radius;
	DensityProfile 	_rayleigh_density;
	vec3 			_rayleigh_scattering;
	DensityProfile 	_mie_density;
	vec3			_mie_scattering;
	vec3 			_mie_extinction;
	float 			_mie_phase_function_g;
	DensityProfile 	_absorption_density;
	vec3 			_absorption_extinction;
	vec3 			_ground_albedo;
	float 			_mu_s_min;
};

